var continents =
[
{
    continent: 'Africa',
    cities:
    [
{ city:'Abidjan',     timezone:'Africa/Abidjan' },
{ city:'Accra',       timezone:'Africa/Accra' },
{ city:'Addis_Ababa',       timezone:'Africa/Addis_Ababa' },
{ city:'Algiers',       timezone:'Africa/Algiers' },
{ city:'Asmara',       timezone:'Africa/Asmara' },
{ city:'Asmera',       timezone:'Africa/Asmera' },
{ city:'Bamako',       timezone:'Africa/Bamako' },
{ city:'Bangui',       timezone:'Africa/Bangui' },
{ city:'Banjul',       timezone:'Africa/Banjul' },
{ city:'Bissau',       timezone:'Africa/Bissau' },
{ city:'Blantyre',       timezone:'Africa/Blantyre' },
{ city:'Brazzaville',       timezone:'Africa/Brazzaville' },
{ city:'Bujumbura',       timezone:'Africa/Bujumbura' },
{ city:'Cairo',       timezone:'Africa/Cairo' },
{ city:'Casablanca',       timezone:'Africa/Casablanca' },
{ city:'Ceuta',       timezone:'Africa/Ceuta' },
{ city:'Conakry',       timezone:'Africa/Conakry' },
{ city:'Dakar',       timezone:'Africa/Dakar' },
{ city:'Dar_es_Salaam',       timezone:'Africa/Dar_es_Salaam' },
{ city:'Djibouti',       timezone:'Africa/Djibouti' },
{ city:'Douala',       timezone:'Africa/Douala' },
{ city:'El_Aaiun',       timezone:'Africa/El_Aaiun' },
{ city:'Freetown',       timezone:'Africa/Freetown' },
{ city:'Gaborone',       timezone:'Africa/Gaborone' },
{ city:'Harare',       timezone:'Africa/Harare' },
{ city:'Johannesburg',       timezone:'Africa/Johannesburg' },
{ city:'Juba',       timezone:'Africa/Juba' },
{ city:'Kampala',       timezone:'Africa/Kampala' },
{ city:'Khartoum',       timezone:'Africa/Khartoum' },
{ city:'Kigali',       timezone:'Africa/Kigali' },
{ city:'Kinshasa',       timezone:'Africa/Kinshasa' },
{ city:'Lagos',       timezone:'Africa/Lagos' },
{ city:'Libreville',       timezone:'Africa/Libreville' },
{ city:'Lome',       timezone:'Africa/Lome' },
{ city:'Luanda',       timezone:'Africa/Luanda' },
{ city:'Lubumbashi',       timezone:'Africa/Lubumbashi' },
{ city:'Lusaka',       timezone:'Africa/Lusaka' },
{ city:'Malabo',       timezone:'Africa/Malabo' },
{ city:'Maputo',       timezone:'Africa/Maputo' },
{ city:'Maseru',       timezone:'Africa/Maseru' },
{ city:'Mbabane',       timezone:'Africa/Mbabane' },
{ city:'Mogadishu',       timezone:'Africa/Mogadishu' },
{ city:'Monrovia',       timezone:'Africa/Monrovia' },
{ city:'Nairobi',       timezone:'Africa/Nairobi' },
{ city:'Ndjamena',       timezone:'Africa/Ndjamena' },
{ city:'Niamey',       timezone:'Africa/Niamey' },
{ city:'Nouakchott',       timezone:'Africa/Nouakchott' },
{ city:'Ouagadougou',       timezone:'Africa/Ouagadougou' },
{ city:'Porto-Novo',       timezone:'Africa/Porto-Novo' },
{ city:'Sao_Tome',       timezone:'Africa/Sao_Tome' },
{ city:'Timbuktu',       timezone:'Africa/Timbuktu' },
{ city:'Tripoli',       timezone:'Africa/Tripoli' },
{ city:'Tunis',       timezone:'Africa/Tunis' },
{ city:'Windhoek',       timezone:'Africa/Windhoek' }
    ]
},
{
    continent: 'America',
    cities:
    [
{ city:'Adak',       timezone:'America/Adak' },
{ city:'Anchorage',       timezone:'America/Anchorage' },
{ city:'Anguilla',       timezone:'America/Anguilla' },
{ city:'Antigua',       timezone:'America/Antigua' },
{ city:'Araguaina',       timezone:'America/Araguaina' },
{ city:'Aruba',       timezone:'America/Aruba' },
{ city:'Asuncion',       timezone:'America/Asuncion' },
{ city:'Atikokan',       timezone:'America/Atikokan' },
{ city:'Atka',       timezone:'America/Atka' },
{ city:'Bahia',       timezone:'America/Bahia' },
{ city:'Bahia_Banderas',       timezone:'America/Bahia_Banderas' },
{ city:'Barbados',       timezone:'America/Barbados' },
{ city:'Belem',       timezone:'America/Belem' },
{ city:'Belize',       timezone:'America/Belize' },
{ city:'Blanc-Sablon',       timezone:'America/Blanc-Sablon' },
{ city:'Boa_Vista',       timezone:'America/Boa_Vista' },
{ city:'Bogota',       timezone:'America/Bogota' },
{ city:'Boise',       timezone:'America/Boise' },
{ city:'Buenos_Aires',       timezone:'America/Buenos_Aires' },
{ city:'Cambridge_Bay',       timezone:'America/Cambridge_Bay' },
{ city:'Campo_Grande',       timezone:'America/Campo_Grande' },
{ city:'Cancun',       timezone:'America/Cancun' },
{ city:'Caracas',       timezone:'America/Caracas' },
{ city:'Catamarca',       timezone:'America/Catamarca' },
{ city:'Cayenne',       timezone:'America/Cayenne' },
{ city:'Cayman',       timezone:'America/Cayman' },
{ city:'Chicago',       timezone:'America/Chicago' },
{ city:'Chihuahua',       timezone:'America/Chihuahua' },
{ city:'Coral_Harbour',       timezone:'America/Coral_Harbour' },
{ city:'Cordoba',       timezone:'America/Cordoba' },
{ city:'Costa_Rica',       timezone:'America/Costa_Rica' },
{ city:'Creston',       timezone:'America/Creston' },
{ city:'Cuiaba',       timezone:'America/Cuiaba' },
{ city:'Curacao',       timezone:'America/Curacao' },
{ city:'Danmarkshavn',       timezone:'America/Danmarkshavn' },
{ city:'Dawson',       timezone:'America/Dawson' },
{ city:'Dawson_Creek',       timezone:'America/Dawson_Creek' },
{ city:'Denver',       timezone:'America/Denver' },
{ city:'Detroit',       timezone:'America/Detroit' },
{ city:'Dominica',       timezone:'America/Dominica' },
{ city:'Edmonton',       timezone:'America/Edmonton' },
{ city:'Eirunepe',       timezone:'America/Eirunepe' },
{ city:'El_Salvador',       timezone:'America/El_Salvador' },
{ city:'Ensenada',       timezone:'America/Ensenada' },
{ city:'Fort_Wayne',       timezone:'America/Fort_Wayne' },
{ city:'Fortaleza',       timezone:'America/Fortaleza' },
{ city:'Glace_Bay',       timezone:'America/Glace_Bay' },
{ city:'Godthab',       timezone:'America/Godthab' },
{ city:'Goose_Bay',       timezone:'America/Goose_Bay' },
{ city:'Grand_Turk',       timezone:'America/Grand_Turk' },
{ city:'Grenada',       timezone:'America/Grenada' },
{ city:'Guadeloupe',       timezone:'America/Guadeloupe' },
{ city:'Guatemala',       timezone:'America/Guatemala' },
{ city:'Guayaquil',       timezone:'America/Guayaquil' },
{ city:'Guyana',       timezone:'America/Guyana' },
{ city:'Halifax',       timezone:'America/Halifax' },
{ city:'Havana',       timezone:'America/Havana' },
{ city:'Hermosillo',       timezone:'America/Hermosillo' },
{ city:'Indianapolis',       timezone:'America/Indianapolis' },
{ city:'Inuvik',       timezone:'America/Inuvik' },
{ city:'Iqaluit',       timezone:'America/Iqaluit' },
{ city:'Jamaica',       timezone:'America/Jamaica' },
{ city:'Jujuy',       timezone:'America/Jujuy' },
{ city:'Juneau',       timezone:'America/Juneau' },
{ city:'Knox_IN',       timezone:'America/Knox_IN' },
{ city:'Kralendijk',       timezone:'America/Kralendijk' },
{ city:'La_Paz',       timezone:'America/La_Paz' },
{ city:'Lima',       timezone:'America/Lima' },
{ city:'Los_Angeles',       timezone:'America/Los_Angeles' },
{ city:'Louisville',       timezone:'America/Louisville' },
{ city:'Lower_Princes',       timezone:'America/Lower_Princes' },
{ city:'Maceio',       timezone:'America/Maceio' },
{ city:'Managua',       timezone:'America/Managua' },
{ city:'Manaus',       timezone:'America/Manaus' },
{ city:'Marigot',       timezone:'America/Marigot' },
{ city:'Martinique',       timezone:'America/Martinique' },
{ city:'Matamoros',       timezone:'America/Matamoros' },
{ city:'Mazatlan',       timezone:'America/Mazatlan' },
{ city:'Mendoza',       timezone:'America/Mendoza' },
{ city:'Menominee',       timezone:'America/Menominee' },
{ city:'Merida',       timezone:'America/Merida' },
{ city:'Metlakatla',       timezone:'America/Metlakatla' },
{ city:'Mexico_City',       timezone:'America/Mexico_City' },
{ city:'Miquelon',       timezone:'America/Miquelon' },
{ city:'Moncton',       timezone:'America/Moncton' },
{ city:'Monterrey',       timezone:'America/Monterrey' },
{ city:'Montevideo',       timezone:'America/Montevideo' },
{ city:'Montreal',       timezone:'America/Montreal' },
{ city:'Montserrat',       timezone:'America/Montserrat' },
{ city:'Nassau',       timezone:'America/Nassau' },
{ city:'New_York',       timezone:'America/New_York' },
{ city:'Nipigon',       timezone:'America/Nipigon' },
{ city:'Nome',       timezone:'America/Nome' },
{ city:'Noronha',       timezone:'America/Noronha' },
{ city:'Ojinaga',       timezone:'America/Ojinaga' },
{ city:'Panama',       timezone:'America/Panama' },
{ city:'Pangnirtung',       timezone:'America/Pangnirtung' },
{ city:'Paramaribo',       timezone:'America/Paramaribo' },
{ city:'Phoenix',       timezone:'America/Phoenix' },
{ city:'Port-au-Prince',       timezone:'America/Port-au-Prince' },
{ city:'Port_of_Spain',       timezone:'America/Port_of_Spain' },
{ city:'Porto_Acre',       timezone:'America/Porto_Acre' },
{ city:'Porto_Velho',       timezone:'America/Porto_Velho' },
{ city:'Puerto_Rico',       timezone:'America/Puerto_Rico' },
{ city:'Rainy_River',       timezone:'America/Rainy_River' },
{ city:'Rankin_Inlet',       timezone:'America/Rankin_Inlet' },
{ city:'Recife',       timezone:'America/Recife' },
{ city:'Regina',       timezone:'America/Regina' },
{ city:'Resolute',       timezone:'America/Resolute' },
{ city:'Rio_Branco',       timezone:'America/Rio_Branco' },
{ city:'Rosario',       timezone:'America/Rosario' },
{ city:'Santa_Isabel',       timezone:'America/Santa_Isabel' },
{ city:'Santarem',       timezone:'America/Santarem' },
{ city:'Santiago',       timezone:'America/Santiago' },
{ city:'Santo_Domingo',       timezone:'America/Santo_Domingo' },
{ city:'Sao_Paulo',       timezone:'America/Sao_Paulo' },
{ city:'Scoresbysund',       timezone:'America/Scoresbysund' },
{ city:'Shiprock',       timezone:'America/Shiprock' },
{ city:'Sitka',       timezone:'America/Sitka' },
{ city:'St_Barthelemy',       timezone:'America/St_Barthelemy' },
{ city:'St_Johns',       timezone:'America/St_Johns' },
{ city:'St_Kitts',       timezone:'America/St_Kitts' },
{ city:'St_Lucia',       timezone:'America/St_Lucia' },
{ city:'St_Thomas',       timezone:'America/St_Thomas' },
{ city:'St_Vincent',       timezone:'America/St_Vincent' },
{ city:'Swift_Current',       timezone:'America/Swift_Current' },
{ city:'Tegucigalpa',       timezone:'America/Tegucigalpa' },
{ city:'Thule',       timezone:'America/Thule' },
{ city:'Thunder_Bay',       timezone:'America/Thunder_Bay' },
{ city:'Tijuana',       timezone:'America/Tijuana' },
{ city:'Toronto',       timezone:'America/Toronto' },
{ city:'Tortola',       timezone:'America/Tortola' },
{ city:'Vancouver',       timezone:'America/Vancouver' },
{ city:'Virgin',       timezone:'America/Virgin' },
{ city:'Whitehorse',       timezone:'America/Whitehorse' },
{ city:'Winnipeg',       timezone:'America/Winnipeg' },
{ city:'Yakutat',       timezone:'America/Yakutat' },
{ city:'Yellowknife',       timezone:'America/Yellowknife' }
    ]
},
{
    continent: 'Antarctica',
    cities:
    [
{ city:'Casey',       timezone:'Antarctica/Casey' },
{ city:'Davis',       timezone:'Antarctica/Davis' },
{ city:'DumontDUrville',       timezone:'Antarctica/DumontDUrville' },
{ city:'Macquarie',       timezone:'Antarctica/Macquarie' },
{ city:'Mawson',       timezone:'Antarctica/Mawson' },
{ city:'McMurdo',       timezone:'Antarctica/McMurdo' },
{ city:'Palmer',       timezone:'Antarctica/Palmer' },
{ city:'Rothera',       timezone:'Antarctica/Rothera' },
{ city:'South_Pole',       timezone:'Antarctica/South_Pole' },
{ city:'Syowa',       timezone:'Antarctica/Syowa' },
{ city:'Troll',       timezone:'Antarctica/Troll' },
{ city:'Vostok',       timezone:'Antarctica/Vostok' }
    ]
},
{
    continent: 'Arctic',
    cities:
    [
    	{ city:'Longyearbyen', timezone:'Arctic/Longyearbyen' }
    ]
},
{
    continent: 'Asia',
    cities:
    [
{ city:'Aden',       timezone:'Asia/Aden' },
{ city:'Almaty',       timezone:'Asia/Almaty' },
{ city:'Amman',       timezone:'Asia/Amman' },
{ city:'Anadyr',       timezone:'Asia/Anadyr' },
{ city:'Aqtau',       timezone:'Asia/Aqtau' },
{ city:'Aqtobe',       timezone:'Asia/Aqtobe' },
{ city:'Ashgabat',       timezone:'Asia/Ashgabat' },
{ city:'Ashkhabad',       timezone:'Asia/Ashkhabad' },
{ city:'Baghdad',       timezone:'Asia/Baghdad' },
{ city:'Bahrain',       timezone:'Asia/Bahrain' },
{ city:'Baku',       timezone:'Asia/Baku' },
{ city:'Bangkok',       timezone:'Asia/Bangkok' },
{ city:'Beirut',       timezone:'Asia/Beirut' },
{ city:'Bishkek',       timezone:'Asia/Bishkek' },
{ city:'Brunei',       timezone:'Asia/Brunei' },
{ city:'Calcutta',       timezone:'Asia/Calcutta' },
{ city:'Chita',       timezone:'Asia/Chita' },
{ city:'Choibalsan',       timezone:'Asia/Choibalsan' },
{ city:'Chongqing',       timezone:'Asia/Chongqing' },
{ city:'Chungking',       timezone:'Asia/Chungking' },
{ city:'Colombo',       timezone:'Asia/Colombo' },
{ city:'Dacca',       timezone:'Asia/Dacca' },
{ city:'Damascus',       timezone:'Asia/Damascus' },
{ city:'Dhaka',       timezone:'Asia/Dhaka' },
{ city:'Dili',       timezone:'Asia/Dili' },
{ city:'Dubai',       timezone:'Asia/Dubai' },
{ city:'Dushanbe',       timezone:'Asia/Dushanbe' },
{ city:'Gaza',       timezone:'Asia/Gaza' },
{ city:'Harbin',       timezone:'Asia/Harbin' },
{ city:'Hebron',       timezone:'Asia/Hebron' },
{ city:'Ho_Chi_Minh',       timezone:'Asia/Ho_Chi_Minh' },
{ city:'Hong_Kong',       timezone:'Asia/Hong_Kong' },
{ city:'Hovd',       timezone:'Asia/Hovd' },
{ city:'Irkutsk',       timezone:'Asia/Irkutsk' },
{ city:'Istanbul',       timezone:'Asia/Istanbul' },
{ city:'Jakarta',       timezone:'Asia/Jakarta' },
{ city:'Jayapura',       timezone:'Asia/Jayapura' },
{ city:'Jerusalem',       timezone:'Asia/Jerusalem' },
{ city:'Kabul',       timezone:'Asia/Kabul' },
{ city:'Kamchatka',       timezone:'Asia/Kamchatka' },
{ city:'Karachi',       timezone:'Asia/Karachi' },
{ city:'Kashgar',       timezone:'Asia/Kashgar' },
{ city:'Kathmandu',       timezone:'Asia/Kathmandu' },
{ city:'Katmandu',       timezone:'Asia/Katmandu' },
{ city:'Khandyga',       timezone:'Asia/Khandyga' },
{ city:'Kolkata',       timezone:'Asia/Kolkata' },
{ city:'Krasnoyarsk',       timezone:'Asia/Krasnoyarsk' },
{ city:'Kuala_Lumpur',       timezone:'Asia/Kuala_Lumpur' },
{ city:'Kuching',       timezone:'Asia/Kuching' },
{ city:'Kuwait',       timezone:'Asia/Kuwait' },
{ city:'Macao',       timezone:'Asia/Macao' },
{ city:'Macau',       timezone:'Asia/Macau' },
{ city:'Magadan',       timezone:'Asia/Magadan' },
{ city:'Makassar',       timezone:'Asia/Makassar' },
{ city:'Manila',       timezone:'Asia/Manila' },
{ city:'Muscat',       timezone:'Asia/Muscat' },
{ city:'Nicosia',       timezone:'Asia/Nicosia' },
{ city:'Novokuznetsk',       timezone:'Asia/Novokuznetsk' },
{ city:'Novosibirsk',       timezone:'Asia/Novosibirsk' },
{ city:'Omsk',       timezone:'Asia/Omsk' },
{ city:'Oral',       timezone:'Asia/Oral' },
{ city:'Phnom_Penh',       timezone:'Asia/Phnom_Penh' },
{ city:'Pontianak',       timezone:'Asia/Pontianak' },
{ city:'Pyongyang',       timezone:'Asia/Pyongyang' },
{ city:'Qatar',       timezone:'Asia/Qatar' },
{ city:'Qyzylorda',       timezone:'Asia/Qyzylorda' },
{ city:'Rangoon',       timezone:'Asia/Rangoon' },
{ city:'Riyadh',       timezone:'Asia/Riyadh' },
{ city:'Saigon',       timezone:'Asia/Saigon' },
{ city:'Sakhalin',       timezone:'Asia/Sakhalin' },
{ city:'Samarkand',       timezone:'Asia/Samarkand' },
{ city:'Seoul',       timezone:'Asia/Seoul' },
{ city:'Shanghai',       timezone:'Asia/Shanghai' },
{ city:'Singapore',       timezone:'Asia/Singapore' },
{ city:'Srednekolymsk',       timezone:'Asia/Srednekolymsk' },
{ city:'Taipei',       timezone:'Asia/Taipei' },
{ city:'Tashkent',       timezone:'Asia/Tashkent' },
{ city:'Tbilisi',       timezone:'Asia/Tbilisi' },
{ city:'Tehran',       timezone:'Asia/Tehran' },
{ city:'Tel_Aviv',       timezone:'Asia/Tel_Aviv' },
{ city:'Thimbu',       timezone:'Asia/Thimbu' },
{ city:'Thimphu',       timezone:'Asia/Thimphu' },
{ city:'Tokyo',       timezone:'Asia/Tokyo' },
{ city:'Ujung_Pandang',       timezone:'Asia/Ujung_Pandang' },
{ city:'Ulaanbaatar',       timezone:'Asia/Ulaanbaatar' },
{ city:'Ulan_Bator',       timezone:'Asia/Ulan_Bator' },
{ city:'Urumqi',       timezone:'Asia/Urumqi' },
{ city:'Ust-Nera',       timezone:'Asia/Ust-Nera' },
{ city:'Vientiane',       timezone:'Asia/Vientiane' },
{ city:'Vladivostok',       timezone:'Asia/Vladivostok' },
{ city:'Yakutsk',       timezone:'Asia/Yakutsk' },
{ city:'Yekaterinburg',       timezone:'Asia/Yekaterinburg' },
{ city:'Yerevan',       timezone:'Asia/Yerevan' }
	]
},
{
    continent: 'Atlantic',
    cities:
    [
{ city:'Azores',       timezone:'Atlantic/Azores' },
{ city:'Bermuda',       timezone:'Atlantic/Bermuda' },
{ city:'Canary',       timezone:'Atlantic/Canary' },
{ city:'Cape_Verde',       timezone:'Atlantic/Cape_Verde' },
{ city:'Faeroe',       timezone:'Atlantic/Faeroe' },
{ city:'Faroe',       timezone:'Atlantic/Faroe' },
{ city:'Jan_Mayen',       timezone:'Atlantic/Jan_Mayen' },
{ city:'Madeira',       timezone:'Atlantic/Madeira' },
{ city:'Reykjavik',       timezone:'Atlantic/Reykjavik' },
{ city:'South_Georgia',       timezone:'Atlantic/South_Georgia' },
{ city:'St_Helena',       timezone:'Atlantic/St_Helena' },
{ city:'Stanley',       timezone:'Atlantic/Stanley' }
    ]
},
{
    continent: 'Australia',
    cities:
    [
{ city:'ACT',       timezone:'Australia/ACT' },
{ city:'Adelaide',       timezone:'Australia/Adelaide' },
{ city:'Brisbane',       timezone:'Australia/Brisbane' },
{ city:'Broken_Hill',       timezone:'Australia/Broken_Hill' },
{ city:'Canberra',       timezone:'Australia/Canberra' },
{ city:'Currie',       timezone:'Australia/Currie' },
{ city:'Darwin',       timezone:'Australia/Darwin' },
{ city:'Eucla',       timezone:'Australia/Eucla' },
{ city:'Hobart',       timezone:'Australia/Hobart' },
{ city:'LHI',       timezone:'Australia/LHI' },
{ city:'Lindeman',       timezone:'Australia/Lindeman' },
{ city:'Lord_Howe',       timezone:'Australia/Lord_Howe' },
{ city:'Melbourne',       timezone:'Australia/Melbourne' },
{ city:'NSW',       timezone:'Australia/NSW' },
{ city:'North',       timezone:'Australia/North' },
{ city:'Perth',       timezone:'Australia/Perth' },
{ city:'Queensland',       timezone:'Australia/Queensland' },
{ city:'South',       timezone:'Australia/South' },
{ city:'Sydney',       timezone:'Australia/Sydney' },
{ city:'Tasmania',       timezone:'Australia/Tasmania' },
{ city:'Victoria',       timezone:'Australia/Victoria' },
{ city:'West',       timezone:'Australia/West' },
{ city:'Yancowinna',       timezone:'Australia/Yancowinna' }
    ]
},
{
    continent: 'Europe',
    cities:
    [
{ city:'Amsterdam',       timezone:'Europe/Amsterdam' },
{ city:'Andorra',       timezone:'Europe/Andorra' },
{ city:'Athens',       timezone:'Europe/Athens' },
{ city:'Belfast',       timezone:'Europe/Belfast' },
{ city:'Belgrade',       timezone:'Europe/Belgrade' },
{ city:'Berlin',       timezone:'Europe/Berlin' },
{ city:'Bratislava',       timezone:'Europe/Bratislava' },
{ city:'Brussels',       timezone:'Europe/Brussels' },
{ city:'Bucharest',       timezone:'Europe/Bucharest' },
{ city:'Budapest',       timezone:'Europe/Budapest' },
{ city:'Busingen',       timezone:'Europe/Busingen' },
{ city:'Chisinau',       timezone:'Europe/Chisinau' },
{ city:'Copenhagen',       timezone:'Europe/Copenhagen' },
{ city:'Dublin',       timezone:'Europe/Dublin' },
{ city:'Gibraltar',       timezone:'Europe/Gibraltar' },
{ city:'Guernsey',       timezone:'Europe/Guernsey' },
{ city:'Helsinki',       timezone:'Europe/Helsinki' },
{ city:'Isle_of_Man',       timezone:'Europe/Isle_of_Man' },
{ city:'Istanbul',       timezone:'Europe/Istanbul' },
{ city:'Jersey',       timezone:'Europe/Jersey' },
{ city:'Kaliningrad',       timezone:'Europe/Kaliningrad' },
{ city:'Kiev',       timezone:'Europe/Kiev' },
{ city:'Lisbon',       timezone:'Europe/Lisbon' },
{ city:'Ljubljana',       timezone:'Europe/Ljubljana' },
{ city:'London',       timezone:'Europe/London' },
{ city:'Luxembourg',       timezone:'Europe/Luxembourg' },
{ city:'Madrid',       timezone:'Europe/Madrid' },
{ city:'Malta',       timezone:'Europe/Malta' },
{ city:'Mariehamn',       timezone:'Europe/Mariehamn' },
{ city:'Minsk',       timezone:'Europe/Minsk' },
{ city:'Monaco',       timezone:'Europe/Monaco' },
{ city:'Moscow',       timezone:'Europe/Moscow' },
{ city:'Nicosia',       timezone:'Europe/Nicosia' },
{ city:'Oslo',       timezone:'Europe/Oslo' },
{ city:'Paris',       timezone:'Europe/Paris' },
{ city:'Podgorica',       timezone:'Europe/Podgorica' },
{ city:'Prague',       timezone:'Europe/Prague' },
{ city:'Riga',       timezone:'Europe/Riga' },
{ city:'Rome',       timezone:'Europe/Rome' },
{ city:'Samara',       timezone:'Europe/Samara' },
{ city:'San_Marino',       timezone:'Europe/San_Marino' },
{ city:'Sarajevo',       timezone:'Europe/Sarajevo' },
{ city:'Simferopol',       timezone:'Europe/Simferopol' },
{ city:'Skopje',       timezone:'Europe/Skopje' },
{ city:'Sofia',       timezone:'Europe/Sofia' },
{ city:'Stockholm',       timezone:'Europe/Stockholm' },
{ city:'Tallinn',       timezone:'Europe/Tallinn' },
{ city:'Tirane',       timezone:'Europe/Tirane' },
{ city:'Tiraspol',       timezone:'Europe/Tiraspol' },
{ city:'Uzhgorod',       timezone:'Europe/Uzhgorod' },
{ city:'Vaduz',       timezone:'Europe/Vaduz' },
{ city:'Vatican',       timezone:'Europe/Vatican' },
{ city:'Vienna',       timezone:'Europe/Vienna' },
{ city:'Vilnius',       timezone:'Europe/Vilnius' },
{ city:'Volgograd',       timezone:'Europe/Volgograd' },
{ city:'Warsaw',       timezone:'Europe/Warsaw' },
{ city:'Zagreb',       timezone:'Europe/Zagreb' },
{ city:'Zaporozhye',       timezone:'Europe/Zaporozhye' },
{ city:'Zurich',       timezone:'Europe/Zurich' }
    ]
},
{
    continent: 'Indian',
    cities:
    [
{ city:'Antananarivo',       timezone:'Indian/Antananarivo' },
{ city:'Chagos',       timezone:'Indian/Chagos' },
{ city:'Christmas',       timezone:'Indian/Christmas' },
{ city:'Cocos',       timezone:'Indian/Cocos' },
{ city:'Comoro',       timezone:'Indian/Comoro' },
{ city:'Kerguelen',       timezone:'Indian/Kerguelen' },
{ city:'Mahe',       timezone:'Indian/Mahe' },
{ city:'Maldives',       timezone:'Indian/Maldives' },
{ city:'Mauritius',       timezone:'Indian/Mauritius' },
{ city:'Mayotte',       timezone:'Indian/Mayotte' },
{ city:'Reunion',       timezone:'Indian/Reunion' }
    ]
},
{
    continent: 'Pacific',
    cities:
    [
{ city:'Apia',       timezone:'Pacific/Apia' },
{ city:'Auckland',       timezone:'Pacific/Auckland' },
{ city:'Bougainville',       timezone:'Pacific/Bougainville' },
{ city:'Chatham',       timezone:'Pacific/Chatham' },
{ city:'Chuuk',       timezone:'Pacific/Chuuk' },
{ city:'Easter',       timezone:'Pacific/Easter' },
{ city:'Efate',       timezone:'Pacific/Efate' },
{ city:'Enderbury',       timezone:'Pacific/Enderbury' },
{ city:'Fakaofo',       timezone:'Pacific/Fakaofo' },
{ city:'Fiji',       timezone:'Pacific/Fiji' },
{ city:'Funafuti',       timezone:'Pacific/Funafuti' },
{ city:'Galapagos',       timezone:'Pacific/Galapagos' },
{ city:'Gambier',       timezone:'Pacific/Gambier' },
{ city:'Guadalcanal',       timezone:'Pacific/Guadalcanal' },
{ city:'Guam',       timezone:'Pacific/Guam' },
{ city:'Honolulu',       timezone:'Pacific/Honolulu' },
{ city:'Johnston',       timezone:'Pacific/Johnston' },
{ city:'Kiritimati',       timezone:'Pacific/Kiritimati' },
{ city:'Kosrae',       timezone:'Pacific/Kosrae' },
{ city:'Kwajalein',       timezone:'Pacific/Kwajalein' },
{ city:'Majuro',       timezone:'Pacific/Majuro' },
{ city:'Marquesas',       timezone:'Pacific/Marquesas' },
{ city:'Midway',       timezone:'Pacific/Midway' },
{ city:'Nauru',       timezone:'Pacific/Nauru' },
{ city:'Niue',       timezone:'Pacific/Niue' },
{ city:'Norfolk',       timezone:'Pacific/Norfolk' },
{ city:'Noumea',       timezone:'Pacific/Noumea' },
{ city:'Pago_Pago',       timezone:'Pacific/Pago_Pago' },
{ city:'Palau',       timezone:'Pacific/Palau' },
{ city:'Pitcairn',       timezone:'Pacific/Pitcairn' },
{ city:'Pohnpei',       timezone:'Pacific/Pohnpei' },
{ city:'Ponape',       timezone:'Pacific/Ponape' },
{ city:'Port_Moresby',       timezone:'Pacific/Port_Moresby' },
{ city:'Rarotonga',       timezone:'Pacific/Rarotonga' },
{ city:'Saipan',       timezone:'Pacific/Saipan' },
{ city:'Samoa',       timezone:'Pacific/Samoa' },
{ city:'Tahiti',       timezone:'Pacific/Tahiti' },
{ city:'Tarawa',       timezone:'Pacific/Tarawa' },
{ city:'Tongatapu',       timezone:'Pacific/Tongatapu' },
{ city:'Truk',       timezone:'Pacific/Truk' },
{ city:'Wake',       timezone:'Pacific/Wake' },
{ city:'Wallis',       timezone:'Pacific/Wallis' },
{ city:'Yap',       timezone:'Pacific/Yap' }
    ]
},
{
    continent: 'Etc',
    cities:
    [
{ city:'GMT',       timezone:'Etc/GMT' },
{ city:'GMT+0',       timezone:'Etc/GMT+0' },
{ city:'GMT+1',       timezone:'Etc/GMT+1' },
{ city:'GMT+10',       timezone:'Etc/GMT+10' },
{ city:'GMT+11',       timezone:'Etc/GMT+11' },
{ city:'GMT+12',       timezone:'Etc/GMT+12' },
{ city:'GMT+2',       timezone:'Etc/GMT+2' },
{ city:'GMT+3',       timezone:'Etc/GMT+3' },
{ city:'GMT+4',       timezone:'Etc/GMT+4' },
{ city:'GMT+5',       timezone:'Etc/GMT+5' },
{ city:'GMT+6',       timezone:'Etc/GMT+6' },
{ city:'GMT+7',       timezone:'Etc/GMT+7' },
{ city:'GMT+8',       timezone:'Etc/GMT+8' },
{ city:'GMT+9',       timezone:'Etc/GMT+9' },
{ city:'GMT-0',       timezone:'Etc/GMT-0' },
{ city:'GMT-1',       timezone:'Etc/GMT-1' },
{ city:'GMT-10',       timezone:'Etc/GMT-10' },
{ city:'GMT-11',       timezone:'Etc/GMT-11' },
{ city:'GMT-12',       timezone:'Etc/GMT-12' },
{ city:'GMT-13',       timezone:'Etc/GMT-13' },
{ city:'GMT-14',       timezone:'Etc/GMT-14' },
{ city:'GMT-2',       timezone:'Etc/GMT-2' },
{ city:'GMT-3',       timezone:'Etc/GMT-3' },
{ city:'GMT-4',       timezone:'Etc/GMT-4' },
{ city:'GMT-5',       timezone:'Etc/GMT-5' },
{ city:'GMT-6',       timezone:'Etc/GMT-6' },
{ city:'GMT-7',       timezone:'Etc/GMT-7' },
{ city:'GMT-8',       timezone:'Etc/GMT-8' },
{ city:'GMT-9',       timezone:'Etc/GMT-9' },
{ city:'GMT0',       timezone:'Etc/GMT0' },
{ city:'Greenwich',       timezone:'Etc/Greenwich' },
{ city:'UCT',       timezone:'Etc/UCT' },
{ city:'UTC',       timezone:'Etc/UTC' },
{ city:'Universal',       timezone:'Etc/Universal' },
{ city:'Zulu',       timezone:'Etc/Zulu' }
    ]
}
]


// Returns the current time in the specified timezone or in your current
// timezone if one is not specified.
function getTime(timezone)
{
    var tz_env_str = "/usr/bin/env TZ=";
    var date_str   = "/bin/date +'%B, %d %Y %H:%M:%S'";
    var time;

    if (timezone)
    {
        time = widget.system(tz_env_str +
                             timezone +
                             " " +
                             date_str,
                             null).outputString;
    }
    else
    {
        time = widget.system(date_str, null).outputString;
    }

    return Date.parse(time);
}

// Returns the time zone difference (in minutes) between any two zoneinfo
// database entries. A blank parameter will be treated as your current timezone.
function timezoneDifference(lhs, rhs)
{
    lhs_time = getTime(lhs);
    rhs_time = getTime(rhs);

    var difference = lhs_time - rhs_time;

    // difference in minutes
    difference = difference / 1000 / 60;

    // times will usually be the same but may sometimes vary but a second
    // so ceil the result to the nearest minute
    difference = Math.ceil(difference);

    return difference;
}

// Returns the 3 character abbreviation of a month (0 - 11)
function monthToShortString(i)
{
    switch (i)
    {
        case 0:  return "Jan";
        case 1:  return "Feb";
        case 2:  return "Mar";
        case 3:  return "Apr";
        case 4:  return "May";
        case 5:  return "Jun";
        case 6:  return "Jul";
        case 7:  return "Aug";
        case 8:  return "Sep";
        case 9:  return "Oct";
        case 10: return "Nov";
        case 11: return "Dec";
    }

    return null;
}

// Returns the 3 character abbreviation of a day of the week (0 - 6)
function dayToShortString(i)
{
    switch (i)
    {
        case 0: return "Sun";
        case 1: return "Mon";
        case 2: return "Tue";
        case 3: return "Wed";
        case 4: return "Thu";
        case 5: return "Fri";
        case 6: return "Sat";
    }

    return null;
}

// Returns a capitalized string of a month (0 - 11)
function monthToString(i)
{
    switch (i)
    {
        case 0:  return "January";
        case 1:  return "February";
        case 2:  return "March";
        case 3:  return "April";
        case 4:  return "May";
        case 5:  return "June";
        case 6:  return "July";
        case 7:  return "August";
        case 8:  return "September";
        case 9:  return "October";
        case 10: return "November";
        case 11: return "December";
    }

    return null;
}

// Returns the month (0 - 11) represented by a capitalized string
function stringToMonth(str)
{
    switch (str)
    {
        case "January":   return 0;
        case "February":  return 1;
        case "March":     return 2;
        case "April":     return 3;
        case "May":       return 4;
        case "June":      return 5;
        case "July":      return 6;
        case "August":    return 7;
        case "September": return 8;
        case "October":   return 9;
        case "November":  return 10;
        case "December":  return 11;
    }

    return null;
}

// Returns the number of days between lhs and rhs
function daysBetween(lhs, rhs)
{
    var ms_in_day = 86400000;

    var lhs_midnight =
        new Date(lhs.getYear(),
                 lhs.getMonth(),
                 lhs.getDate(),
                 0,
                 0,
                 0);

    var rhs_midnight =
        new Date(rhs.getYear(),
                 rhs.getMonth(),
                 rhs.getDate(),
                 0,
                 0,
                 0);

	var days = (rhs_midnight - lhs_midnight) / ms_in_day;

	return Math.round(days);
}

// Returns a pretty formatted date string
function dateToString(date)
{
    var today = new Date();

    formatted_date =
        dayToShortString(date.getDay()) + ", " +
        monthToShortString(date.getMonth()) + " " + date.getDate();

    if (date.getFullYear() != new Date().getFullYear())
    {
        formatted_date += ", " + date.getFullYear();
    }

	return formatted_date;
}
